

mu <- function(x) alpha + t(beta) %*% x

sample_gen_fun <- function (n = n, N = N, p = p,
                            SigmaX = SigmaX, SigmaE = SigmaE, 
                            alpha = alpha, beta = beta, 
                            sd_Y = sd_Y, sd_Q1 = sd_Q1, sd_Q2 = sd_Q2) {
  
  # true covariates
  X <- mvrnorm(n, rep(0, p), Sigma = SigmaX)
  X_new <- mvrnorm(N, rep(0, p), Sigma = SigmaX)
  
  # measurement errors
  SigmaE <- rep(SigmaE, p)
  E <- mvrnorm(n, rep(0, p), Sigma = diag(SigmaE))
  E_new <- mvrnorm(N, rep(0, p), Sigma = diag(SigmaE))
  
  # error-prone covariates
  Z <- X + E
  Z_new <- X_new + E_new
  
  # responses
  mu_Y <- apply(X, 1, mu)
  mu_Y_new <- apply(X_new, 1, mu)
  
  # training responses
  Q <- Q0 <- matrix(nrow = n, ncol = length(u))
  for (i in 1:n) {
    
    Q[i,] <- qnorm(u, mu_Y[i] + rnorm(1, 0, sd_Y), rinvgamma(1, sd_Q1, sd_Q2))
    
    Q0[i,] <- qnorm(u, mu_Y[i], sd_Q2 / (sd_Q1 - 1))
    
  }
  
  # test responses
  Q_new <- Q0_new <- matrix(nrow = N, ncol = length(u))
  for (i in 1:N) {
    
    Q_new[i,] <- qnorm(u, mu_Y_new[i] + rnorm(1, 0, sd_Y), rinvgamma(1, sd_Q1, sd_Q2))
    
    Q0_new[i,] <- qnorm(u, mu_Y_new[i], sd_Q2 / (sd_Q1 - 1))
    
  }
  
  return(list(X = X, X_new = X_new,
              Z = Z, Z_new = Z_new,
              Q = Q, Q_new = Q_new,
              Q0 = Q0, Q0_new = Q0_new))
}


frechet_lambda_fun <- function (lambda = 0, 
                                X = X, Z = Z, Q = Q, X_new = X_new, Q_new = NULL) {
  
  # sample mean of covariates
  barZ <- apply(Z, 2, mean)
  
  # SVD
  svd_Z <- svd(scale(Z, center = TRUE, scale = FALSE))
  U_Z <- svd_Z$u
  D_Z <- svd_Z$d
  V_Z <- svd_Z$v
  
  # hard thresholding
  D_Z_lambda <- ifelse(D_Z/sqrt(n) > lambda, D_Z, 0)
  inv_D_Z_lambda <- ifelse(D_Z/sqrt(n) > lambda, 1/D_Z_lambda, 0)
  dim_svt <- sum(inv_D_Z_lambda > 0)
  
  # low-rank approximation
  Z_lambda <- U_Z %*% diag(D_Z_lambda) %*% t(V_Z)  
  
  # estimation (training) 
  w_hat_svt <- 1 + n * t((t(Z) - barZ)) %*% (V_Z %*% diag(inv_D_Z_lambda^2) %*% t(V_Z)) %*% (t(X) - barZ)
  Q_hat_svt <- t(apply(t(w_hat_svt) %*% Q / apply(w_hat_svt, 2, sum), 1, sort))
  
  SSE_svt <- apply((Q - Q_hat_svt)^2, 1, sum)*diff(u)[1]
  MSE_svt <- mean(SSE_svt)
  
  # prediction (test)
  w_pred_svt <- 1 + n * t((t(Z) - barZ)) %*% (V_Z %*% diag(inv_D_Z_lambda^2) %*% t(V_Z)) %*% (t(X_new) - barZ)
  Q_pred_svt <- t(apply(t(w_pred_svt) %*% Q / apply(w_pred_svt, 2, sum), 1, sort))
  
  if (is.null(Q_new)) {
    
    MSPE_svt <- NULL
    
  } else {
    
    SSPE_svt <- apply((Q_new - Q_pred_svt)^2, 1, sum)*diff(u)[1]
    MSPE_svt <- mean(SSPE_svt)
    
  }
  
  return(list(lambda = lambda,
              dim = dim_svt,
              Q_hat = Q_hat_svt,
              Q_pred = Q_pred_svt,
              MSE = MSE_svt,
              MSPE = MSPE_svt))
}



